/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.datasource.rmi.ObjectNotFoundException;
import de.willuhn.jameica.messaging.ReminderMessage;
import de.willuhn.jameica.reminder.Reminder;
import de.willuhn.jameica.reminder.ReminderInterval;
import de.willuhn.jameica.reminder.ReminderStorageProvider;
import de.willuhn.jameica.reminder.ReminderStorageProviderWallet;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.MessagingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.MultipleClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;

public class ReminderService
extends TimerTask
implements Bootable {
    private Timer timer = null;
    private ReminderStorageProvider jameicaProvider = null;
    private List<ReminderStorageProvider> providers = new ArrayList<ReminderStorageProvider>();

    public Class[] depends() {
        return new Class[]{MessagingService.class};
    }

    public ReminderStorageProvider getDefaultProvider() {
        return this.jameicaProvider;
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        try {
            Class[] classes;
            BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            this.jameicaProvider = service.get(ReminderStorageProviderWallet.class);
            MultipleClassLoader cl = Application.getClassLoader();
            for (Class c : classes = cl.getClassFinder().findImplementors(ReminderStorageProvider.class)) {
                try {
                    this.providers.add((ReminderStorageProvider)service.get(c));
                }
                catch (Exception e) {
                    Logger.error((String)("unable to load reminder storage provider " + c), (Throwable)e);
                }
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, 4000L, 60000L);
        }
        catch (Exception e) {
            Logger.error((String)"error while starting reminder service", (Throwable)e);
        }
    }

    public void shutdown() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception e) {
            Logger.error((String)"error while shutting down reminder service", (Throwable)e);
        }
        finally {
            this.jameicaProvider = null;
            this.providers.clear();
        }
    }

    @Override
    public void run() {
        Date now = new Date();
        long timeout = now.getTime() - 1209600000L;
        for (ReminderStorageProvider provider : this.providers) {
            try {
                Map<String, Reminder> reminders = provider.find(null, null, now);
                for (String uuid : reminders.keySet()) {
                    Reminder r = reminders.get(uuid);
                    try {
                        ReminderInterval ri = r.getReminderInterval();
                        Date date = r.getDate();
                        Date end = r.getEnd();
                        Date last = (Date)r.getData("jameica.reminder.key.executed");
                        Date expired = (Date)r.getData("jameica.reminder.key.expired");
                        if (expired != null) continue;
                        if (last != null && ri == null) {
                            if (last.getTime() >= timeout) continue;
                            Logger.info((String)("deleting old reminder " + uuid + ", message sent on: " + last));
                            provider.delete(uuid);
                            continue;
                        }
                        if (end != null && end.before(now) && (last != null && last.after(end) || ri.getDates(date, last, end).size() == 0)) {
                            Logger.info((String)("mark old recurring reminder " + uuid + " as expired, end date: " + end));
                            r.setData("jameica.reminder.key.expired", now);
                            provider.update(uuid, r);
                            continue;
                        }
                        String queue = StringUtils.trimToNull((String)r.getQueue());
                        if (queue == null) {
                            queue = "jameica.reminder";
                        }
                        if (ri == null) {
                            Logger.info((String)("sending reminder message for " + uuid + " to " + queue + " - due to: " + date));
                            Application.getMessagingFactory().getMessagingQueue(queue).sendMessage(new ReminderMessage(date, uuid, r.getData()));
                        } else {
                            List<Date> dates = ri.getDates(date, last, now);
                            for (Date d : dates) {
                                if (end != null && end.before(d)) continue;
                                Logger.info((String)("sending reminder message for " + uuid + " to " + queue + " - due to: " + d));
                                Application.getMessagingFactory().getMessagingQueue(queue).sendMessage(new ReminderMessage(d, uuid, r.getData()));
                            }
                        }
                        r.setData("jameica.reminder.key.executed", now);
                        provider.update(uuid, r);
                    }
                    catch (ObjectNotFoundException onf) {
                        Logger.warn((String)("reminder " + r + " has been deleted by message consumer"));
                    }
                    catch (Exception e) {
                        Logger.error((String)("unable to send reminder " + r + " from provider " + provider.getClass().getName()), (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                Logger.error((String)("unable to send reminder messages for provider " + provider.getClass().getName()), (Throwable)t);
            }
        }
    }
}

